﻿using System;
using System.Runtime.Serialization;

namespace gov.va.med.VBECS.Communication.Common
{
    /// <summary>
    /// Communication exception (for example "TCP socket is closed")
    /// </summary>
    [Serializable]
    public class CommunicationException : Exception
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public CommunicationException()
        {

        }

        /// <summary>
        /// Constructor for serializing.
        /// </summary>
        public CommunicationException(SerializationInfo serializationInfo, StreamingContext context)
            : base(serializationInfo, context)
        {

        }

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="message">Exception message</param>
        public CommunicationException(string message)
            : base(message)
        {

        }

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="message">Exception message</param>
        /// <param name="innerException">Inner exception</param>
        public CommunicationException(string message, Exception innerException)
            : base(message, innerException)
        {

        }
    }
}
